//------------------------------------------------------------------------------
// Tumar CSP
// Copyright (c) 2011 Scientific Lab. Gamma Technologies. All rights reserved.
// SDK
// Verify Signature PKCS-7 message
//------------------------------------------------------------------------------
#include "ex_util.h"
//------------------------------------------------------------------------------
#define PKCS7S_FILE "pkcs7_sig.bin"
#define CMP_RA_CERT "us3.cer"
char *Data_for_sign=(char*)"1234567890ABCD";
//------------------------------------------------------------------------------
//    
// :
// 1.     PKCS#7
//------------------------------------------------------------------------------
unsigned char WBuf[8196];
unsigned char Cert[8196];
//------------------------------------------------------------------------------
int main(void)
{
 int code;
 HCRYPTPROV hProv=0;
 HCRYPTKEY  hKey;
 HCRYPTHASH hHash;
 DWORD sz,sc;

 //  
 code=LoadTumarCSP((char*)CSP_LIB); if (code) {printf("Load CSP error: %d\n",code); return 1;}
 //
 //  PKCS7
 if (getFileLen(PKCS7S_FILE,    &sz)) {printf("getFileLen error\r\n"); return 1;}
 if (readFile  (PKCS7S_FILE,WBuf,sz)) {printf("readFile error\r\n");   return 1;}
 //
 //  
 if (getFileLen(CMP_RA_CERT,    &sc)) {printf("getFileLen error\r\n"); return 1;}
 if (readFile  (CMP_RA_CERT,Cert,sc)) {printf("readFile error\r\n");   return 1;}
 //
 //   CSP
 if (!CPAcquireContext(&hProv,NULL,CRYPT_VERIFYCONTEXT,NULL)) {
   printf("CPAcquireContext Error: %0X\n",GetLastErrorCSP(0));
   return 1;
 }
 //     
 if (!CPImportKey(hProv,Cert,sc,0,0,&hKey)) {
   printf("CPImportKey Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //  -
 if (!CPCreateHash(hProv,CALG_TGR3411,0,0,&hHash)) {
   printf("CPCreateHash Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //  
 if (!CPHashData(hProv,hHash,(BYTE*)Data_for_sign,strlen(Data_for_sign),0)) {
   printf("CPHashData Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 //  
 if (!CPVerifySignature(hProv,hHash,WBuf,sz,hKey,0,0)) {
   printf("CPVerifySignature Error: %0X\n",GetLastErrorCSP(hProv));
   return 1;
 }
 CPDestroyHash(hProv,hHash);
 CPDestroyKey (hProv,hKey);
 //   CSP
 CPReleaseContext(hProv,0);
 printf("OK\n");
 return 0;
}
//------------------------------------------------------------------------------
